
//Chris' WinGlide enhancements
//Copr. 1998, Chris Dohnal (cwdohnal@ucdavis.edu)

#include <windows.h>
#include "sysmenu.h"
#include "inifile.h"
#include "gammadlg.h"
#include "main.h"

//System menu options
#define IDM_GAMMA_CORRECTION	2000
#define IDM_RESET_WINDOW_SIZE	2001
static const char szGammaCorrection[] = "&Gamma correction";
static const char szResetWindowSize[] = "Reset &window size";


BOOL AddWinGlideSystemMenuOptions(HWND, DWORD);
VOID RemoveWinGlideSystemMenuOptions(HWND);
BOOL HandleWinGlideSystemMenuOptions(HWND, WPARAM, LPARAM);

BOOL ResetWinGlideWindowSize(HWND);


BOOL AddWinGlideSystemMenuOptions(HWND hWnd, DWORD dwMode) {
	HMENU hSystemMenu;
	int iMenuItemCount;
	int iNextMenuItem;
	MENUITEMINFO menuItemInfo;
	BOOL bRet;

	//Get the system menu handle
	hSystemMenu = GetSystemMenu(hWnd, FALSE);

	//See how many items are in the menu
	iMenuItemCount = GetMenuItemCount(hSystemMenu);
	if (iMenuItemCount == -1) {
		//Return FALSE if GetMenuItemCount fails
		return FALSE;
	}

	//Setup iNextMenuItem
	iNextMenuItem = iMenuItemCount;

	//Initialize the menu item info structure
	menuItemInfo.cbSize = sizeof(menuItemInfo);

	//Add an item to the system menu
	menuItemInfo.fMask = MIIM_TYPE;
	menuItemInfo.fType = MFT_SEPARATOR;
	bRet = InsertMenuItem(hSystemMenu, iNextMenuItem, TRUE, &menuItemInfo);
	iNextMenuItem++;

	//Add an item to the system menu
	if (gbEnableGammaCorrection == TRUE) {
		menuItemInfo.fMask = MIIM_ID | MIIM_TYPE;
		menuItemInfo.wID = IDM_GAMMA_CORRECTION;
		menuItemInfo.fType = MFT_STRING;
		menuItemInfo.dwTypeData = (LPTSTR)szGammaCorrection;
		bRet = InsertMenuItem(hSystemMenu, iNextMenuItem, TRUE, &menuItemInfo);
		iNextMenuItem++;
	}

	//Add an item to the system menu
	switch (dwMode) {
	case WINGLIDE_MODE_STRETCH_BLT:
	case WINGLIDE_MODE_OVERLAY:
	case WINGLIDE_MODE_OFF_SCREEN_SURFACE:
		menuItemInfo.fMask = MIIM_ID | MIIM_TYPE;
		menuItemInfo.wID = IDM_RESET_WINDOW_SIZE;
		menuItemInfo.fType = MFT_STRING;
		menuItemInfo.dwTypeData = (LPTSTR)szResetWindowSize;
		bRet = InsertMenuItem(hSystemMenu, iNextMenuItem, TRUE, &menuItemInfo);
		iNextMenuItem++;
		break;

	case WINGLIDE_MODE_B2:
	default:
		;
	}


	return TRUE;
}

VOID RemoveWinGlideSystemMenuOptions(HWND hWnd) {
	//Reset the system menu
	GetSystemMenu(hWnd, TRUE);

	return;
}

BOOL HandleWinGlideSystemMenuOptions(HWND hWnd, WPARAM wParam, LPARAM lParam) {
	//See if this message was from an option that was added to the system menu
	switch (wParam) {
	case IDM_GAMMA_CORRECTION:
		//Display the gamma correction dialog box
		ShowWinGlideGammaDialog(hWnd, gRedGamma, gGreenGamma, gBlueGamma);

		break;

	case IDM_RESET_WINDOW_SIZE:
		//Reset the window size
		ResetWinGlideWindowSize(hWnd);
		break;

	default:
		//Return FALSE since a system menu command was not handled
		return FALSE;
	}

	//Return TRUE since a system menu command was handled
	return TRUE;
}

BOOL ResetWinGlideWindowSize(HWND hWnd) {
	HMENU hMenu;
	BOOL bHasMenu;
	RECT rect;
	LONG lStyle, lExStyle;
	BOOL bRet;
	LONG lWidth, lHeight;

	//See if the window has a menu
	hMenu = GetMenu(hWnd);
	if (hMenu != NULL) {
		bHasMenu = TRUE;
	}
	else {
		bHasMenu = FALSE;
	}

	//Calculate the window size needed for a certain client size
	rect.left = 0;
	rect.top = 0;
	rect.right = gdwScreenWidth;
	rect.bottom = gdwScreenHeight;
	lStyle = GetWindowLong(hWnd, GWL_STYLE);
	lExStyle = GetWindowLong(hWnd, GWL_EXSTYLE);

	bRet = AdjustWindowRectEx(&rect, lStyle, bHasMenu, lExStyle);
	if (bRet == FALSE) {
		return FALSE;
	}

	//Calculate the width and height of the window
	lWidth = rect.right - rect.left;
	lHeight = rect.bottom - rect.top;

	//Restore the window if it is maximized or iconic
	//Check for iconic first
	bRet = IsIconic(hWnd);
	if (bRet) {
		ShowWindow(hWnd, SW_RESTORE);
	}
	//Check for maximized second in case the window is maximized after being restored from an icon
	bRet = IsZoomed(hWnd);
	if (bRet) {
		ShowWindow(hWnd, SW_RESTORE);
	}

	//Get the window's rectangle
	bRet = GetWindowRect(hWnd, &rect);
	//Make sure the window is displayed on the screen
	if (rect.left < 0) {
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.top = 0;
	}
	if (bRet) {
		MoveWindow(hWnd, rect.left, rect.top, lWidth, lHeight, TRUE);
	}

	return TRUE;
}
